/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.commons.event.invoker.dynamic;

import dev.yumi.commons.event.invoker.InvokerFactory;
import dev.yumi.commons.event.invoker.dynamic.Descriptors;
import dev.yumi.commons.event.invoker.dynamic.OpcodeUtils;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@ApiStatus.Internal
abstract class DynamicInvokerFactory<T>
extends InvokerFactory<T> {
    private static final String SELF_BINARY_NAME = DynamicInvokerFactory.class.getName().replace('.', '/');
    private static final Module MODULE = DynamicInvokerFactory.class.getModule();
    protected static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    protected final MethodType listenerMethodType;
    protected final MethodType lambdaMethodType;
    protected final Function<T[], T> factory;

    protected DynamicInvokerFactory(@NotNull Class<? super T> type) {
        this(type, DynamicInvokerFactory.getFunctionalMethod(type));
    }

    protected DynamicInvokerFactory(@NotNull Class<? super T> type, @NotNull Method listenerMethod) {
        super(type);
        this.checkMethod(listenerMethod);
        this.ensureModuleConstraints(listenerMethod);
        try {
            this.listenerMethodType = MethodType.methodType(listenerMethod.getReturnType(), listenerMethod.getParameterTypes());
            this.lambdaMethodType = this.listenerMethodType.insertParameterTypes(0, new Class[]{type.arrayType()});
            String implementationInnerClassRawName = this.type.getSimpleName() + "Impl";
            String implName = "$" + this.getClass().getSimpleName();
            String implementationFullInnerClassRawName = DynamicInvokerFactory.class.getSimpleName() + implName;
            String implementationClassRawName = SELF_BINARY_NAME + implName;
            this.factory = this.buildClass(listenerMethod.getName(), this.type.getName().replace('.', '/'), new ImplementationName(implementationInnerClassRawName, implementationFullInnerClassRawName, implementationClassRawName));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new DynamicInvokerCreationException("Failed to generate the dynamic invoker factory", e);
        }
    }

    @Contract(pure=true)
    protected abstract void checkMethod(@NotNull Method var1);

    private void ensureModuleConstraints(@NotNull Method method) {
        MODULE.addReads(this.type.getModule());
        DynamicInvokerFactory.ensureModuleConstraintForType(method.getReturnType());
        for (Class<?> paramType : method.getParameterTypes()) {
            DynamicInvokerFactory.ensureModuleConstraintForType(paramType);
        }
    }

    private static void ensureModuleConstraintForType(@NotNull Class<?> type) {
        if (type.isPrimitive()) {
            return;
        }
        if (type.isArray()) {
            DynamicInvokerFactory.ensureModuleConstraintForType(type.componentType());
            return;
        }
        MODULE.addReads(type.getModule());
    }

    private Function<T[], T> buildClass(String listenerMethodName, String typeRawName, ImplementationName name) throws IllegalAccessException, NoSuchMethodException {
        String factoryDescriptor = MethodType.methodType(this.type, this.type.arrayType()).toMethodDescriptorString();
        ClassWriter cw = new ClassWriter(3);
        cw.visit(61, 49, name.classRawName(), "Ljava/util/function/Function<[L" + typeRawName + ";" + typeRawName + ";>;", "java/lang/Object", new String[]{"java/util/function/Function"});
        cw.visitSource(name.fullInnerClassRawName(), null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(4161, "apply", "(Ljava/lang/Object;)Ljava/lang/Object;", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, "[L" + typeRawName + ";");
        mv.visitMethodInsn(182, name.classRawName(), "apply", "([L%s;)L%s;".formatted(typeRawName, typeRawName), false);
        mv.visitInsn(176);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        mv = cw.visitMethod(4106, "lambda$apply", this.lambdaMethodType.toMethodDescriptorString(), null, null);
        WriterContext context = new WriterContext(listenerMethodName, typeRawName, name.innerClassName(), name.fullInnerClassRawName(), name.classRawName(), this.getParamTable());
        this.writeImplementationMethod(mv, context);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "apply", factoryDescriptor, null, null);
        mv.visitVarInsn(25, 1);
        mv.visitInvokeDynamicInsn(listenerMethodName, factoryDescriptor, new Handle(6, SELF_BINARY_NAME, "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false), new Object[]{Descriptors.asmType(this.listenerMethodType), new Handle(6, name.classRawName(), "lambda$apply", this.lambdaMethodType.toMethodDescriptorString(), false), Descriptors.asmType(this.listenerMethodType)});
        mv.visitInsn(176);
        mv.visitMaxs(1, 2);
        mv.visitEnd();
        byte[] bytes = cw.toByteArray();
        MethodHandles.Lookup lookup = LOOKUP.defineHiddenClass(bytes, true, new MethodHandles.Lookup.ClassOption[0]);
        MethodHandle constructor = lookup.findConstructor(lookup.lookupClass(), MethodType.methodType(Void.TYPE));
        try {
            return constructor.invoke();
        }
        catch (Throwable e) {
            throw new DynamicInvokerCreationException("Failed to instantiate the generated invoker factory constructor.", e);
        }
    }

    static CallSite metafactory(MethodHandles.Lookup caller, String interfaceMethodName, MethodType factoryType, MethodType interfaceMethodType, MethodHandle implementation, MethodType dynamicMethodType) throws Throwable {
        MethodHandle invoker = MethodHandles.exactInvoker(implementation.type());
        if (factoryType.parameterCount() == 0) {
            factoryType = factoryType.appendParameterTypes(MethodHandle.class);
            CallSite cs = LambdaMetafactory.metafactory(caller, interfaceMethodName, factoryType, interfaceMethodType, invoker, dynamicMethodType);
            Object instance = cs.dynamicInvoker().asType(MethodType.methodType(Object.class, MethodHandle.class)).invokeExact(implementation);
            return new ConstantCallSite(MethodHandles.constant(factoryType.returnType(), instance));
        }
        MethodType lambdaMt = factoryType.insertParameterTypes(0, MethodHandle.class);
        CallSite cs = LambdaMetafactory.metafactory(caller, interfaceMethodName, lambdaMt, interfaceMethodType, invoker, dynamicMethodType);
        return new ConstantCallSite(cs.dynamicInvoker().bindTo(implementation));
    }

    protected abstract void writeImplementationMethod(MethodVisitor var1, WriterContext var2);

    protected void writeMethodStart(MethodVisitor mv, WriterContext context) {
        this.preparePreLoop(mv, context);
        this.writeLoopStart(mv, context);
        for (LocalEntry param : context.paramTable().params()) {
            mv.visitVarInsn(OpcodeUtils.getLoadOpcodeFromType(param.type()), param.index());
        }
        context.writeMethodInvoke(mv);
    }

    protected void preparePreLoop(MethodVisitor mv, WriterContext context) {
        mv.visitVarInsn(25, context.listenersVar());
        mv.visitInsn(190);
        mv.visitVarInsn(54, context.listenersLengthVar);
        mv.visitInsn(3);
        mv.visitVarInsn(54, context.iVar);
    }

    protected void writeLoopStart(MethodVisitor mv, WriterContext context) {
        mv.visitLabel(context.forStartLabel);
        mv.visitVarInsn(21, context.iVar);
        mv.visitVarInsn(21, context.listenersLengthVar);
        mv.visitJumpInsn(162, context.forEndLabel);
        mv.visitLabel(new Label());
        mv.visitVarInsn(25, context.listenersVar());
        mv.visitVarInsn(21, context.iVar);
        mv.visitInsn(50);
    }

    protected void writeIncrement(MethodVisitor mv, WriterContext context) {
        mv.visitLabel(new Label());
        mv.visitIincInsn(context.iVar, 1);
        mv.visitJumpInsn(167, context.forStartLabel);
    }

    @Override
    public T apply(T[] listeners) {
        if (listeners.length == 1) {
            return listeners[0];
        }
        return this.factory.apply((T[][])listeners);
    }

    protected ParamTable getParamTable() {
        ArrayList<LocalEntry> params = new ArrayList<LocalEntry>();
        int localStart = 1;
        for (int i = 0; i < this.listenerMethodType.parameterCount(); ++i) {
            TypeDescriptor.OfField paramType = this.listenerMethodType.parameterType(i);
            params.add(new LocalEntry(localStart, (Class<?>)paramType));
            if (paramType == Long.TYPE || paramType == Double.TYPE) {
                localStart += 2;
                continue;
            }
            ++localStart;
        }
        return new ParamTable(localStart, params);
    }

    private record ImplementationName(String innerClassName, String outerClassRawName, String outerClassFullRawName) {
        public String fullInnerClassRawName() {
            return this.outerClassRawName + "$" + this.innerClassName;
        }

        public String classRawName() {
            return this.outerClassFullRawName + "$" + this.innerClassName;
        }
    }

    static class DynamicInvokerCreationException
    extends RuntimeException {
        public DynamicInvokerCreationException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    protected class WriterContext {
        private final String listenerMethodName;
        private final String typeRawName;
        private final String implementationInnerClassRawName;
        private final String implementationFullInnerClassRawName;
        private final String implementationClassRawName;
        private final ParamTable paramTable;
        private final int listenersLengthVar;
        private final int iVar;
        private final Label forStartLabel = new Label();
        private final Label forEndLabel = new Label();

        WriterContext(String listenerMethodName, String typeRawName, String implementationInnerClassRawName, String implementationFullInnerClassRawName, String implementationClassRawName, ParamTable paramTable) {
            this.listenerMethodName = listenerMethodName;
            this.typeRawName = typeRawName;
            this.implementationInnerClassRawName = implementationInnerClassRawName;
            this.implementationFullInnerClassRawName = implementationFullInnerClassRawName;
            this.implementationClassRawName = implementationClassRawName;
            this.paramTable = paramTable;
            this.listenersLengthVar = paramTable.localStart + 1;
            this.iVar = this.listenersLengthVar + 1;
        }

        public String listenerMethodName() {
            return this.listenerMethodName;
        }

        public String typeRawName() {
            return this.typeRawName;
        }

        public String implementationInnerClassRawName() {
            return this.implementationInnerClassRawName;
        }

        public String implementationFullInnerClassRawName() {
            return this.implementationFullInnerClassRawName;
        }

        public String implementationClassRawName() {
            return this.implementationClassRawName;
        }

        public ParamTable paramTable() {
            return this.paramTable;
        }

        public int listenersVar() {
            return 0;
        }

        public int listenersLengthVar() {
            return this.listenersLengthVar;
        }

        public int iVar() {
            return this.iVar;
        }

        public Label getForStartLabel() {
            return this.forStartLabel;
        }

        public Label getForEndLabel() {
            return this.forEndLabel;
        }

        public void writeMethodInvoke(MethodVisitor mv) {
            mv.visitMethodInsn(185, this.typeRawName, this.listenerMethodName, DynamicInvokerFactory.this.listenerMethodType.toMethodDescriptorString(), true);
        }
    }

    protected record ParamTable(int localStart, List<LocalEntry> params) {
    }

    protected record LocalEntry(int index, Class<?> type) {
    }
}

